DEFINT A-Z
'$INCLUDE: '64blaz.bi'
DECLARE SUB AddBackScroll (RowNum%)
DECLARE SUB Load64Set (Set%)
DECLARE FUNCTION TimeDiff& (Mark&)
DECLARE FUNCTION Time& ()
DECLARE FUNCTION CCap$ (Strg$)
DECLARE SUB TTYCR ()
DECLARE SUB SetBordColr (Attr%)
'INCLUDE: '64DECLAR.BI'
DIM SHARED FKey%(255), NormKey%(255), CmKey%(255), Outt%(255)
DIM SHARED Pal%(15), CxPalSave%(15), DxPalSave%(15)
COMMON SHARED FKey%(), NormKey%(), CmKey%(), Outt%()
COMMON SHARED Pal%(), CxPalSave%(), DxPalSave%()
COMMON SHARED Scrn AS STRING * 2080
COMMON SHARED CharSet AS STRING * 4096
DIM SHARED LineBuff AS STRING * 80

CONST MaxChars% = 80
'MaxChars% is the maximum number of characters that can be read at once
'by TRead.

FUNCTION CCap$ (Strg$)
  IF Set% = 1 THEN CCap$ = UCASE$(Strg$) ELSE CCap$ = LCASE$(Strg$)
END FUNCTION

SUB ClearBlk (BTop%, BLeft%, BBot%, BRight%, BFore%, BBack%)
  Regs.ax = &H600
  Regs.bx = VAL("&H" + HEX$(BBack% * 4096& + BFore% * 256&))
  Regs.cx = (BTop% - 1) * 256 + BLeft% - 1
  Regs.dx = (BBot% - 1) * 256 + BRight% - 1
  interrupt &H10, Regs, Regs
END SUB

SUB Get40 (CurFlag%)
  IF CurFlag% THEN
    Row% = CSRLIN
    Col% = POS(0)
    ORow% = Row%
    OCol% = Col%
    OColr% = Colr%
    OBack% = Back%
    OBord% = Bord%
    Oset% = Set%
  END IF
  GetBlock VARSEG(Scrn), VARPTR(Scrn), 1, 1, 25, 40
END SUB

SUB GetaKey (Keyy$)
  DO
    Keyy$ = INKEY$
  LOOP UNTIL LEN(Keyy$)
END SUB

SUB Load64Set (Set%)
  ' C64set - for qb4.5 by R. Hooper with help from the one and only M. Rejhon
  ' use 0 for te first set, 1 for the second set.

  'Install character set into EGA/VGA video RAM
  RegsX.ax = &H1100
  RegsX.bx = &H800
  RegsX.cx = &H100
  RegsX.dx = &H0
  RegsX.es = VARSEG(CharSet) + (Set% AND 1) * 128
  RegsX.bp = VARPTR(CharSet)
  INTERRUPTX &H10, RegsX, RegsX
END SUB

SUB Palet (Attr%, Red%, Green%, Blue%)
  Regs.ax = &H1010
  Regs.bx = Attr%
  Regs.cx = VAL("&H" + HEX$(Blue% + Green% * 256))
  Regs.dx = VAL("&H" + HEX$(Red% * 256))
  interrupt &H10, Regs, Regs
END SUB

SUB Put40 (CurFlag%)
  IF CurFlag% THEN
    Row% = ORow%
    Col% = OCol%
    LOCATE Row%, Col%
    Colr% = OColr%
    Back% = OBack%
    Bord% = OBord%
    IF Set% <> Oset% THEN Load64Set Oset%
    Set% = Oset%
    SetBordColr Bord%
  END IF
  PutBlock VARSEG(Scrn), VARPTR(Scrn), 1, 1, 25, 40
END SUB

SUB RestorePalet
  IF PaletTest% = 2 THEN
    FOR Pal% = 0 TO 15
      Regs.ax = &H1010
      Regs.bx = Pal%
      Regs.cx = CxPalSave%(Pal%)
      Regs.dx = DxPalSave%(Pal%)
      interrupt &H10, Regs, Regs
    NEXT Pal%
  END IF
  FOR Pal% = 0 TO 7
    PALETTE Pal%, Pal%
    PALETTE Pal% + 8, Pal% + 56
  NEXT Pal%
END SUB

SUB SavePalet
  IF PaletTest% = 2 THEN
    FOR Pall% = 0 TO 15
      Regs.ax = &H1015
      Regs.bx = Pall%
      interrupt &H10, Regs, Regs
      CxPalSave%(Pall%) = Regs.cx
      DxPalSave%(Pall%) = Regs.dx
    NEXT Pall%
  END IF
END SUB

SUB SetBordColr (Attr%)
  Regs.ax = &H1001
  IF PaletTest% = 2 THEN
    Regs.bx = Attr% * 256
  ELSE
    Regs.bx = Pal%(Attr%) * 256
  END IF
  Regs.cx = &H0
  Regs.dx = &H0
  interrupt &H10, Regs, Regs
END SUB

FUNCTION Time&
  Regs.ax = &H2C00
  interrupt &H21, Regs, Regs
  Time& = (Regs.dx AND &HFF&) + (Regs.dx AND &HFF00&) / 256 * 100 + (Regs.cx AND &HFF&) * 6000 + (Regs.cx AND &H1F00&) / 256 * 360000
END FUNCTION

FUNCTION TimeDiff& (Mark&)
  IF Mark& < 0 THEN Mark& = Mark& + 8640000    'Number of secs in day * 100
  TDiff& = Time& - Mark&
  IF TDiff& < 0 THEN TimeDiff& = TDiff& + 8640000 ELSE TimeDiff& = TDiff&
END FUNCTION

SUB TRead (Messg$)
  Mes$ = ""
  CharC% = 0
  DO WHILE TCInStat% AND CharC% < MaxChars%
    Mes$ = Mes$ + TCInkey$
    CharC% = CharC% + 1
  LOOP
  Messg$ = Mes$
END SUB

SUB TTY (Char%)
  IF reverse% THEN Char% = Char% + 128
  LOCATE Row%, Col%
  Regs.ax = &H900 + Char%
  Regs.bx = Colr% + Back% * 16
  Regs.cx = 1
  interrupt &H10, Regs, Regs
  IF Col% < Wid% THEN
    Col% = Col% + 1
  ELSE
    AddBackScroll (Row%)
    Col% = 1
    IF Row% < Height% THEN Row% = Row% + 1 ELSE TTYCR
  END IF
  CurBlinkin% = 0
  CurBlinkTime& = 0
  LOCATE Row%, Col%
END SUB

SUB TTYCR
  COLOR Colr%, Back%
  Regs.ax = &HE00 + 13
  Regs.bx = 0
  interrupt &H10, Regs, Regs
  Regs.ax = &HE00 + 10
  Regs.bx = 0
  interrupt &H10, Regs, Regs
END SUB

SUB TTYStay (Char%, Attr%)
  LOCATE Row%, Col%
  Regs.ax = &H900 + Char%
  Regs.bx = Attr%
  Regs.cx = 1
  interrupt &H10, Regs, Regs
END SUB

SUB Waitt (Delay&, Keyy%)
  Temp& = Time&
  DO
    IF Keyy% THEN IF LEN(INKEY$) THEN EXIT DO
  LOOP UNTIL TimeDiff&(Temp&) > Delay&
END SUB

